package h.com.newserialapp.activity.MIAFREDESFireActivity;

import android.content.Intent;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;

import h.com.newserialapp.R;
import h.com.serialportapi.comn.Reader;

/**
 * Created by hxd on 2018/12/8.
 */

public class MifareDesFireActivity extends AppCompatActivity implements View.OnClickListener {
    private Button btCardSystemCommand, btKeyCommands, btPiccLevel, btApplicationLevel, btBackToMainMenu;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_mifare_des_fire);
        bindView();
    }

    void bindView() {
        Typeface typeface = Typeface.createFromAsset(this.getAssets(), "fonts/Eurostile LT Demi.ttf");
        btCardSystemCommand = findViewById(R.id.bt_card_system_command);
        btKeyCommands = findViewById(R.id.bt_KeyCommands);
        btPiccLevel = findViewById(R.id.bt_picc_level);
        btApplicationLevel = findViewById(R.id.bt_application_level);
        btBackToMainMenu = findViewById(R.id.bt_back_to_main_menu);
        btCardSystemCommand.setTypeface(typeface);
        btKeyCommands.setTypeface(typeface);
        btPiccLevel.setTypeface(typeface);
        btApplicationLevel.setTypeface(typeface);
        btBackToMainMenu.setTypeface(typeface);
        btCardSystemCommand.setOnClickListener(this);
        btKeyCommands.setOnClickListener(this);
        btPiccLevel.setOnClickListener(this);
        btApplicationLevel.setOnClickListener(this);
        btBackToMainMenu.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.bt_card_system_command:
                startActivity(new Intent(this, CardSysCommandActivity.class));
                break;
            case R.id.bt_KeyCommands:
                startActivity(new Intent(this, KeyCommandsActivity.class));
                break;
            case R.id.bt_picc_level:
                startActivity(new Intent(this, PiccLevelActivity.class));
                break;
            case R.id.bt_application_level:
                startActivity(new Intent(this, ApplicationLevelActivity.class));
                break;
            case R.id.bt_back_to_main_menu:
                finish();
                break;
        }
    }
}
